/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.action.impl;

import com.alrex.parcool.client.animation.impl.HangAnimator;
import com.alrex.parcool.client.input.KeyBindings;
import com.alrex.parcool.common.action.Action;
import com.alrex.parcool.common.action.StaminaConsumeTiming;
import com.alrex.parcool.common.action.impl.ClingToCliff;
import com.alrex.parcool.common.action.impl.JumpFromBar;
import com.alrex.parcool.common.capability.IStamina;
import com.alrex.parcool.common.capability.impl.Animation;
import com.alrex.parcool.common.capability.impl.Parkourability;
import com.alrex.parcool.utilities.VectorUtil;
import com.alrex.parcool.utilities.WorldUtil;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;

public class HangDown
extends Action {
    private double bodySwingAngleFactor = 0.0;
    private float armSwingAmount = 0.0f;
    private boolean orthogonalToBar = false;
    private BarAxis hangingBarAxis = null;

    public float getArmSwingAmount() {
        return this.armSwingAmount;
    }

    public double getBodySwingAngleFactor() {
        return this.bodySwingAngleFactor;
    }

    public boolean isOrthogonalToBar() {
        return this.orthogonalToBar;
    }

    @Nullable
    public BarAxis getHangingBarAxis() {
        return this.hangingBarAxis;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean canStart(Player player, Parkourability parkourability, IStamina stamina, ByteBuffer startInfo) {
        startInfo.putDouble(Math.max(-1.0, Math.min(1.0, 3.0 * player.m_20154_().m_82542_(1.0, 0.0, 1.0).m_82541_().m_82526_(player.m_20184_()))));
        return !stamina.isExhausted() && !player.m_6144_() && Math.abs(player.m_20184_().f_82480_) < 0.2 && KeyBindings.getKeyHangDown().m_90857_() && parkourability.getActionInfo().can(HangDown.class) && !parkourability.get(JumpFromBar.class).isDoing() && !parkourability.get(ClingToCliff.class).isDoing() && WorldUtil.getHangableBars((LivingEntity)player) != null;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean canContinue(Player player, Parkourability parkourability, IStamina stamina) {
        return !stamina.isExhausted() && KeyBindings.getKeyHangDown().m_90857_() && parkourability.getActionInfo().can(HangDown.class) && !parkourability.get(JumpFromBar.class).isDoing() && !parkourability.get(ClingToCliff.class).isDoing() && WorldUtil.getHangableBars((LivingEntity)player) != null;
    }

    private void setup(Player player, ByteBuffer startData) {
        this.armSwingAmount = 0.0f;
        this.bodySwingAngleFactor = startData.getDouble();
        this.hangingBarAxis = WorldUtil.getHangableBars((LivingEntity)player);
        Vec3 bodyVec = VectorUtil.fromYawDegree(player.f_20883_);
        this.orthogonalToBar = this.hangingBarAxis == BarAxis.X && Math.abs(bodyVec.f_82479_) < Math.abs(bodyVec.f_82481_) || this.hangingBarAxis == BarAxis.Z && Math.abs(bodyVec.f_82481_) < Math.abs(bodyVec.f_82479_);
        player.m_20334_(0.0, 0.0, 0.0);
        Animation animation = Animation.get(player);
        if (animation != null) {
            animation.setAnimator(new HangAnimator());
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onStartInLocalClient(Player player, Parkourability parkourability, IStamina stamina, ByteBuffer startData) {
        this.setup(player, startData);
    }

    @Override
    public void onStartInOtherClient(Player player, Parkourability parkourability, ByteBuffer startData) {
        this.setup(player, startData);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onWorkingTickInLocalClient(Player player, Parkourability parkourability, IStamina stamina) {
        Vec3 bodyVec = VectorUtil.fromYawDegree(player.f_20883_);
        double speed = 0.1;
        double xSpeed = 0.0;
        double zSpeed = 0.0;
        if (this.orthogonalToBar) {
            if (this.hangingBarAxis == BarAxis.X) {
                xSpeed = (double)(bodyVec.f_82481_ > 0.0 ? 1 : -1) * 0.1;
            } else {
                zSpeed = (double)(bodyVec.f_82479_ > 0.0 ? 1 : -1) * 0.1;
            }
            if (KeyBindings.getKeyLeft().m_90857_()) {
                player.m_20334_(xSpeed, 0.0, -zSpeed);
            } else if (KeyBindings.getKeyRight().m_90857_()) {
                player.m_20334_(-xSpeed, 0.0, zSpeed);
            } else {
                player.m_20334_(0.0, 0.0, 0.0);
            }
        } else {
            if (this.hangingBarAxis == BarAxis.X) {
                xSpeed = (double)(bodyVec.f_82479_ > 0.0 ? 1 : -1) * 0.1;
            } else {
                zSpeed = (double)(bodyVec.f_82481_ > 0.0 ? 1 : -1) * 0.1;
            }
            if (KeyBindings.getKeyForward().m_90857_()) {
                player.m_20334_(xSpeed, 0.0, zSpeed);
            } else if (KeyBindings.getKeyBack().m_90857_()) {
                player.m_20334_(-xSpeed, 0.0, -zSpeed);
            } else {
                player.m_20334_(0.0, 0.0, 0.0);
            }
        }
        this.armSwingAmount = (float)((double)this.armSwingAmount + player.m_20184_().m_82542_(1.0, 0.0, 1.0).m_82556_());
    }

    @Override
    public void onWorkingTickInClient(Player player, Parkourability parkourability, IStamina stamina) {
        this.hangingBarAxis = WorldUtil.getHangableBars((LivingEntity)player);
        Vec3 bodyVec = VectorUtil.fromYawDegree(player.f_20883_);
        boolean bl = this.orthogonalToBar = this.hangingBarAxis == BarAxis.X && Math.abs(bodyVec.f_82479_) < Math.abs(bodyVec.f_82481_) || this.hangingBarAxis == BarAxis.Z && Math.abs(bodyVec.f_82481_) < Math.abs(bodyVec.f_82479_);
        this.bodySwingAngleFactor = this.orthogonalToBar ? (this.bodySwingAngleFactor /= 1.05) : (this.bodySwingAngleFactor /= 1.5);
    }

    @Override
    public void saveSynchronizedState(ByteBuffer buffer) {
        buffer.putFloat(this.armSwingAmount);
    }

    @Override
    public void restoreSynchronizedState(ByteBuffer buffer) {
        this.armSwingAmount = buffer.getFloat();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onRenderTick(TickEvent.RenderTickEvent event, Player player, Parkourability parkourability) {
        if (this.isDoing()) {
            if (this.hangingBarAxis == null) {
                return;
            }
            Vec3 bodyVec = VectorUtil.fromYawDegree(player.f_20883_).m_82541_();
            Vec3 lookVec = player.m_20154_();
            Vec3 idealLookVec = Math.abs(lookVec.f_82479_) > Math.abs(lookVec.f_82481_) ? new Vec3(lookVec.f_82479_ > 0.0 ? 1.0 : -1.0, 0.0, 0.0) : new Vec3(0.0, 0.0, lookVec.f_82481_ > 0.0 ? 1.0 : -1.0);
            double differenceAngle = Math.acos(bodyVec.m_82526_(idealLookVec));
            player.m_5618_((float)VectorUtil.toYawDegree(idealLookVec.m_82524_((float)(differenceAngle /= 4.0))));
        }
    }

    @Override
    public StaminaConsumeTiming getStaminaConsumeTiming() {
        return StaminaConsumeTiming.OnWorking;
    }

    public static enum BarAxis {
        X,
        Z;

    }
}

